package converters

import (
	"testing"
	"time"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestUserProperties(t *testing.T) {
	Convey("when using user properties convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting vinyl user vod properties", func() {
			input := &vinyl.UserVODProperties{
				UserID:                   1234,
				SaveVODsForever:          true,
				VODStorageDays:           100,
				CanUploadVOD:             true,
				YoutubeExportingDisabled: true,
				SkipUploadModeration:     true,
				SkipMuting:               true,
				CanUploadUnlimited:       true,
				CreatedAt:                time.Now(),
				UpdatedAt:                time.Now(),
			}
			output := &models.UserVodPropertiesResponse{
				ChannelID:                input.UserID,
				SaveVodsForever:          input.SaveVODsForever,
				VodStorageDays:           int64(input.VODStorageDays),
				CanUploadVod:             input.CanUploadVOD,
				YoutubeExportingDisabled: input.YoutubeExportingDisabled,
				SkipUploadModeration:     input.SkipUploadModeration,
				SkipMuting:               input.SkipMuting,
				CanUploadUnlimited:       input.CanUploadUnlimited,
				CreatedAt:                input.CreatedAt,
				UpdatedAt:                input.UpdatedAt,
			}
			So(output, ShouldResemble, ConvertVinylUserVodProperties(input))
		})
		Convey("when converting vinyl user video privacy properties", func() {
			input := &vinyl.UserVideoPrivacyProperties{
				UserID:              1234,
				HideArchives:        true,
				HideArchivesEnabled: true,
				CreatedAt:           time.Now(),
				UpdatedAt:           time.Now(),
			}
			output := &models.UserVideoPrivacyPropertiesResponse{
				ChannelID:           input.UserID,
				HideArchives:        input.HideArchives,
				HideArchivesEnabled: input.HideArchivesEnabled,
				CreatedAt:           input.CreatedAt,
				UpdatedAt:           input.UpdatedAt,
			}
			So(output, ShouldResemble, ConvertVinylUserVideoPrivacyProperties(input))
		})
	})
}
