package converters_test

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	"github.com/stretchr/testify/assert"
)

func TestConvertVinylVod(t *testing.T) {
	assert.Equal(t, converters.ConvertVinylVod(testdata.VinylArchiveVod()), &models.Vod{
		BroadcastID:         29548428016,
		BroadcastType:       "archive",
		BroadcasterSoftware: utils.StrPtr("unknown_rtmp"),
		Communities: []string{
			"ec04cef0-0e81-4fa9-a037-d11ac87051b6",
			"fd0eab99-832a-4d7e-8cc0-04d73deb2e54",
			"ff1e77af-551d-4993-945c-f8ceaa2a2829",
		},
		CreatedAt:       utils.StubTimeNow(),
		CreatedBy:       utils.Int64Ptr(136992160),
		DeleteAt:        nil,
		Deleted:         nil,
		Description:     nil,
		DescriptionHTML: nil,
		Duration:        0,
		Fps: map[string]float64{
			"160p30":     30,
			"360p30":     30,
			"480p30":     30,
			"720p30":     30,
			"audio_only": 0,
			"chunked":    26,
		},
		Game:     utils.StrPtr("Music"),
		ID:       286681909,
		Language: utils.StrPtr("en"),
		Manifest: utils.StrPtr("index-dvr.m3u8"),
		Offset:   0,
		Origin:   utils.StrPtr("s3"),
		OwnerID:  136992160,
		Resolutions: map[string]string{
			"160p30":  "284x160",
			"360p30":  "640x360",
			"480p30":  "852x480",
			"720p30":  "1280x720",
			"chunked": "1920x1080",
		},
		SourceArchiveID:  nil,
		StartedOn:        utils.StubTimeNow(),
		Status:           "recording",
		TagList:          []string{""},
		Title:            utils.StrPtr("Positive Quote: Most smiles are started by another smile. #PosiLIVIty 🌻"),
		TotalLength:      7533,
		UpdatedAt:        utils.StubTimeNow(),
		URI:              "238246383b16112fe121_livi_in_the_middle_29548428016_915446914",
		Viewable:         "public",
		ViewableAt:       nil,
		Views:            0,
		PublishedAt:      utils.TimePtr(utils.StubTimeNow()),
		IncrementViewURL: "https://countess.twitch.tv/ping.gif?u=%7B%22id%22%3A%22286681909%22%2C%22type%22%3A%22vod%22%7D",
		Qualities: []string{
			"160p30",
			"360p30",
			"480p30",
			"720p30",
			"audio_only",
			"chunked",
		},
		PreviewTemplate: "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb0-%{width}x%{height}.jpg",
		ShowFormats: map[string]models.ShowFormat{
			"160p30": models.ShowFormat{
				Bitrate:            230000,
				Codecs:             "avc1.4D400C,mp4a.40.2",
				DisplayName:        "160p30",
				Fps:                30,
				MaxIdrInterval:     0,
				PlaylistPreference: 6,
				Resolution:         "284x160",
			},
			"360p30": models.ShowFormat{
				Bitrate:            630000,
				Codecs:             "avc1.4D401E,mp4a.40.2",
				DisplayName:        "360p30",
				Fps:                30,
				MaxIdrInterval:     0,
				PlaylistPreference: 5,
				Resolution:         "640x360",
			},
			"480p30": models.ShowFormat{
				Bitrate:            1200000,
				Codecs:             "avc1.4D401E,mp4a.40.2",
				DisplayName:        "480p30",
				Fps:                30,
				MaxIdrInterval:     0,
				PlaylistPreference: 4,
				Resolution:         "852x480",
			},
			"720p30": models.ShowFormat{
				Bitrate:            2100000,
				Codecs:             "avc1.4D401F,mp4a.40.2",
				DisplayName:        "720p30",
				Fps:                30,
				MaxIdrInterval:     0,
				PlaylistPreference: 3,
				Resolution:         "1280x720",
			},
			"audio_only": models.ShowFormat{
				Bitrate:            161582,
				Codecs:             "mp4a.40.2",
				DisplayName:        "Audio Only",
				Fps:                0,
				MaxIdrInterval:     0,
				PlaylistPreference: 5,
			},
			"chunked": models.ShowFormat{
				Bitrate:            2916316,
				Codecs:             "avc1.640028,mp4a.40.2",
				DisplayName:        "Source",
				Fps:                26,
				MaxIdrInterval:     2000,
				PlaylistPreference: 0,
				Resolution:         "1920x1080",
			},
		},
		ThumbnailTemplates: []models.ThumbnailTemplate{
			models.ThumbnailTemplate{
				Offset: 13.868164,
				Path:   "thumb/thumb0.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb0-%{width}x%{height}.jpg",
			},
			models.ThumbnailTemplate{
				Offset: 43.85984,
				Path:   "thumb/thumb1.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb1-%{width}x%{height}.jpg",
			},
			models.ThumbnailTemplate{
				Offset: 73.82859,
				Path:   "thumb/thumb2.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb2-%{width}x%{height}.jpg",
			},
			models.ThumbnailTemplate{
				Offset: 103.8104,
				Path:   "thumb/thumb3.jpg",
				Type:   "generated",
				URL:    "https://static-cdn.jtvnw.net/s3_vods/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/thumb/thumb3-%{width}x%{height}.jpg",
			},
		},
		SeekPreviewsURL:    "https://vod-storyboards.twitch.tv/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/storyboards/286681909-info.json",
		AnimatedPreviewURL: "https://vod-storyboards.twitch.tv/238246383b16112fe121_livi_in_the_middle_29548428016_915446914/storyboards/286681909-strip-0.jpg",
		Path:               "/videos/286681909",
		URL:                "https://www.twitch.tv/videos/286681909",
	})
}
