package backend

import (
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// CreateArchive should make an underlying call to vinyl
func (b *backendImpl) CreateArchive(ctx context.Context, request *models.CreateArchiveRequest) (*models.Vod, error) {
	b.stats.Inc(createArchiveAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.CreateArchive(ctx, converters.CreateArchiveVodRequest(request), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
