package backend

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// CreateAudibleMagicResponses should make an underlying call to vinyl
func (b *backendImpl) CreateAudibleMagicResponses(ctx context.Context, request *models.CreateAudibleMagicResponsesRequest) (*models.AudibleMagicResponsesResponse, error) {
	b.stats.Inc(createAudibleMagicResponsesAttemptStatStr, 1, 1.0)

	// NOTE: this should only be called by the vod workers for one vod at a time, so this usage pattern is fine
	//       since this logic is temporary, leaving as serial requests for now
	amrs := make([]*vinyl.AMR, len(request.AudibleMagicResponses))
	for i, audibleMagicResponse := range request.AudibleMagicResponses {
		amr, err := b.vinyl.CreateAMR(ctx, converters.ConvertInternalToVinylCreateAudibleMagicResponse(audibleMagicResponse), nil)
		if err != nil {
			return nil, b.ErrorHandle(err)
		}

		amrs[i] = amr
	}
	return converters.ConvertVinylAudibleMagicResponses(amrs), nil
}
