package backend

import (
	"strconv"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// CreateError should make an underlying call to vinyl
func (b *backendImpl) CreateError(ctx context.Context, request *models.CreateErrorRequest) (*models.CreateErrorResponse, error) {
	b.stats.Inc(createErrorAttemptStatStr, 1, 1.0)

	input := vinyl.CreateErrorInput{
		ErrorCode:    request.ErrorCode,
		ErrorMessage: request.ErrorMessage,
	}
	resp, err := b.vinyl.CreateError(ctx, strconv.FormatInt(request.VodID, 10), input, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertCreateError(resp), nil
}
