package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestCreateError(t *testing.T) {
	Convey("when calling CreateError", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.CreateErrorRequest{
			VodID:        testdata.VodID1,
			ErrorCode:    "code",
			ErrorMessage: "message",
		}

		Convey("when CreateError succeeds", func() {
			vinylResp := &vinyl.CreateErrorResponse{
				ErrorCode: "resp_code",
			}
			mocks.vinyl.On("CreateError", ctx, mock.Anything, mock.Anything, mock.Anything).Return(vinylResp, nil)
			resp, err := backend.CreateError(ctx, request)
			So(err, ShouldBeNil)
			So(resp.ErrorCode, ShouldEqual, vinylResp.ErrorCode)
		})
		Convey("when CreateError fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("CreateError", ctx, mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.CreateError(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
