package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// CreateThumbnails should make an underlying call to vinyl
func (b *backendImpl) CreateThumbnails(ctx context.Context, request *models.CreateThumbnailsRequest) (*models.CreateThumbnailsResponse, error) {
	b.stats.Inc(createThumbnailsAttemptStatStr, 1, 1.0)

	createThumbnails, err := b.vinyl.CreateThumbnails(ctx, strconv.FormatInt(request.VodID, 10), converters.ConvertInternalToVinylCreateThumbnails(request), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylCreateThumbnails(createThumbnails), nil
}
