package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestCreateThumbnails(t *testing.T) {
	Convey("when calling CreateThumbnails", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.CreateThumbnailsRequest{
			VodID: testdata.VodID1,
			Thumbnails: []models.ThumbnailRequest{
				models.ThumbnailRequest{
					Path: "path",
				},
			},
		}

		Convey("when CreateThumbnails succeeds", func() {
			thumbnails := testdata.VinylCreateThumbnailsOutput()
			mocks.vinyl.On("CreateThumbnails", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(thumbnails, nil)
			thumbnailsResp, err := backend.CreateThumbnails(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when CreateThumbnails fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("CreateThumbnails", mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.CreateThumbnails(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
