package backend

import (
	"strings"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	vinyl "code.justin.tv/vod/vodapi/pkg/vinyl"
	"golang.org/x/net/context"
)

// CreateUpload should make an underlying call to vinyl
func (b *backendImpl) CreateUpload(ctx context.Context, request *models.CreateUploadRequest) (*models.Vod, error) {
	b.stats.Inc(createUploadAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.CreateUpload(ctx, vinyl.CreateUploadVod{
		BroadcastType:  request.BroadcastType,
		BroadcastID:    request.BroadcastID,
		Status:         "created",
		OwnerID:        request.OwnerID,
		Title:          request.Title,
		Description:    request.Description,
		Duration:       request.Duration,
		URI:            request.URI,
		Manifest:       request.Manifest,
		Game:           request.Game,
		Communities:    request.Communities,
		Language:       request.Language,
		TagList:        strings.Join(request.TagList, ","),
		Viewable:       request.Viewable,
		ViewableAt:     request.ViewableAt,
		CreatePremiere: request.BroadcastType == "premiere_upload",
	}, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
