package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// DeleteThumbnails should make an underlying call to vinyl
func (b *backendImpl) DeleteThumbnails(ctx context.Context, request *models.DeleteThumbnailsRequest) error {
	b.stats.Inc(deleteThumbnailsAttemptStatStr, 1, 1.0)

	err := b.vinyl.DeleteThumbnails(ctx, strconv.FormatInt(request.VodID, 10), nil)
	return b.ErrorHandle(err)
}
