package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestDeleteThumbnails(t *testing.T) {
	Convey("when calling DeleteThumbnails", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.DeleteThumbnailsRequest{
			VodID: testdata.VodID1,
		}

		Convey("when DeleteThumbnails succeeds", func() {
			mocks.vinyl.On("DeleteThumbnails", mock.Anything, mock.Anything, mock.Anything).Return(nil)
			err := backend.DeleteThumbnails(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when DeleteThumbnails fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("DeleteThumbnails", mock.Anything, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.DeleteThumbnails(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
