package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// FinalizeUpload should make an underlying call to vinyl
func (b *backendImpl) FinalizeUpload(ctx context.Context, request *models.FinalizeUploadRequest) error {
	b.stats.Inc(finalizeUploadAttemptStatStr, 1, 1.0)

	err := b.vinyl.FinalizeUpload(ctx, strconv.FormatInt(request.VodID, 10), nil)
	return b.ErrorHandle(err)
}
