package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestFinalizeUpload(t *testing.T) {
	Convey("when calling FinalizeUpload", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.FinalizeUploadRequest{
			VodID: testdata.VodID1,
		}

		Convey("when FinalizeUpload succeeds", func() {
			mocks.vinyl.On("FinalizeUpload", ctx, mock.Anything, mock.Anything).Return(nil)
			err := backend.FinalizeUpload(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when FinalizeUpload fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("FinalizeUpload", ctx, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.FinalizeUpload(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
