package backend

import (
	"strconv"
	"strings"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// GetAudibleMagicResponses should make an underlying call to vinyl
func (b *backendImpl) GetAudibleMagicResponses(ctx context.Context, request *models.GetAudibleMagicResponsesRequest) (*models.AudibleMagicResponsesResponse, error) {
	b.stats.Inc(getAudibleMagicResponsesAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	idsStr := strings.Join(ids, ",")
	audibleMagicResponses, err := b.vinyl.GetAMRs(ctx, idsStr, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylAudibleMagicResponses(audibleMagicResponses), nil
}
