package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetAudibleMagicResponses(t *testing.T) {
	Convey("when calling GetAudibleMagicResponses", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.GetAudibleMagicResponsesRequest{
			VodIDs: []int64{testdata.VodID1},
		}

		Convey("when GetAudibleMagicResponses succeeds", func() {
			audibleMagicResponses := testdata.VinylAudibleMagicResponses()
			mocks.vinyl.On("GetAMRs", mock.Anything, mock.Anything, mock.Anything).Return(audibleMagicResponses, nil)
			thumbnailsResp, err := backend.GetAudibleMagicResponses(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when CreateAudibleMagicResponses fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetAMRs", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.GetAudibleMagicResponses(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
