package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// GetPublicVodAggregationsByIDs should make an underlying call to vinyl
func (b *backendImpl) GetPublicVodAggregationsByIDs(ctx context.Context, request *models.GetPublicVodAggregationsByIDsRequest) (*models.PublicVodAggregationsByIDsResponse, error) {
	b.stats.Inc(getPublicVodAggregationsByIDsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	vodAggregations, err := b.vinyl.GetVodsAggregationByIDs(ctx, ids, nil, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVodAggregations(vodAggregations), nil
}
