package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetPublicVodAggregationsByIDs(t *testing.T) {
	Convey("when calling GetPublicVodAggregationsByIDs", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.GetPublicVodAggregationsByIDsRequest{
			VodIDs: []int64{testdata.VodID1},
		}

		Convey("when GetPublicVodAggregationsByIDs succeeds", func() {
			vodAggregation := &vinyl.VodsAggregation{
				TotalCount:    1,
				TotalDuration: 100,
			}
			mocks.vinyl.On("GetVodsAggregationByIDs", ctx, mock.Anything, (*vinyl.GetVodParams)(nil), mock.Anything).Return(vodAggregation, nil)
			aggregations, err := backend.GetPublicVodAggregationsByIDs(ctx, request)
			So(err, ShouldBeNil)
			So(aggregations.TotalCount, ShouldEqual, 1)
			So(aggregations.TotalDuration, ShouldEqual, 100)
		})
		Convey("when GetPublicVodAggregationsByIDs fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodsAggregationByIDs", ctx, mock.Anything, (*vinyl.GetVodParams)(nil), mock.Anything).Return(nil, vinylErr)
			_, err := backend.GetPublicVodAggregationsByIDs(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
