package backend

import (
	"strings"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// GetTopVods should make an underlying call to vinyl
func (b *backendImpl) GetTopVods(ctx context.Context, request *models.GetTopVodsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(getTopVodsAttemptStatStr, 1, 1.0)

	getTopVodsInput := vinyl.TopInput{
		BroadcastType: strings.Join(request.BroadcastTypes, ","),
		Language:      request.Language,
		Game:          request.Game,
		Period:        request.Period,
		Sort:          request.Sort,
		Limit:         int(request.Limit),
		Offset:        int(request.Offset),
	}
	vinylVods, err := b.vinyl.Top(ctx, getTopVodsInput, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
