package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	vinyl "code.justin.tv/vod/vodapi/pkg/vinyl"
	"golang.org/x/net/context"
)

// GetVodAppeals should make an underlying call to vinyl
func (b *backendImpl) GetVodAppeals(ctx context.Context, request *models.GetVodAppealsRequest) (*models.VodAppealsResponse, error) {
	b.stats.Inc(getVodAppealsAttemptStatStr, 1, 1.0)

	vodIDStr := ""
	if request.VodID > 0 {
		vodIDStr = strconv.FormatInt(request.VodID, 10)
	}
	getAppealsInput := &vinyl.GetAppealsInput{
		Priority: request.Priority,
		Resolved: request.Resolved,
		Limit:    request.Limit,
		Offset:   request.Offset,
		VodID:    vodIDStr,
		UserInfo: request.UserInfo,
	}
	appeals, err := b.vinyl.GetAppeals(ctx, getAppealsInput, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylAppealsResponse(appeals), nil
}
