package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetVodAppeals(t *testing.T) {
	Convey("when calling GetVodAppeals", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		priority := true
		resolved := false
		request := &models.GetVodAppealsRequest{
			Priority: &priority,
			Resolved: &resolved,
			Limit:    100,
			Offset:   0,
			VodID:    testdata.VodID1,
			UserInfo: "user_info",
		}

		Convey("when GetVodAppeals succeeds", func() {
			appeals := testdata.VinylAppeals()
			mocks.vinyl.On("GetAppeals", mock.Anything, mock.Anything, mock.Anything).Return(appeals, nil)
			thumbnailsResp, err := backend.GetVodAppeals(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when GetVodAppeals fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetAppeals", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.GetVodAppeals(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
