package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// GetVodByIDIncludeBannedUsers should make an underlying call to vinyl
func (b *backendImpl) GetVodByIDIncludeBannedUsers(ctx context.Context, request *models.GetVodByIDIncludeBannedUsersRequest) (*models.Vod, error) {
	b.stats.Inc(getVodByIDIncludeBannedUsersAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.GetVodByIDWithDmcaAndTos(ctx, strconv.FormatInt(request.VodID, 10), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
