package backend

import (
	"context"
	"errors"
	"strconv"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetVodByIDIncludeBannedUsers(t *testing.T) {
	Convey("when calling GetVodByIDIncludeBannedUsers", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.GetVodByIDIncludeBannedUsersRequest{
			VodID: testdata.VodID1,
		}

		Convey("when GetVodByIDIncludeBannedUsers succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("GetVodByIDWithDmcaAndTos", ctx, strconv.FormatInt(testdata.VodID1, 10), mock.Anything).Return(vinylUpload, nil)
			vod, err := backend.GetVodByIDIncludeBannedUsers(ctx, request)
			So(err, ShouldBeNil)
			So(internalUpload, ShouldResemble, vod)
		})
		Convey("when GetVodByIDIncludeBannedUsers fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodByIDWithDmcaAndTos", ctx, strconv.FormatInt(testdata.VodID1, 10), mock.Anything).Return(nil, vinylErr)
			_, err := backend.GetVodByIDIncludeBannedUsers(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
