package backend

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// GetVodPopularity should make an underlying call to vinyl
func (b *backendImpl) GetVodPopularity(ctx context.Context, request *models.GetVodPopularityRequest) (*models.VodPopularityResponse, error) {
	b.stats.Inc(getVodPopularityAttemptStatStr, 1, 1.0)

	vodPopularity, err := b.vinyl.GetVodPopularity(ctx, strconv.FormatInt(request.VodID, 10), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVodPopularity(vodPopularity), nil
}
