package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestGetVodPopularity(t *testing.T) {
	Convey("when calling GetVodPopularity", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.GetVodPopularityRequest{
			VodID: testdata.VodID1,
		}

		Convey("when GetVodPopularity succeeds", func() {
			vodAggregation := &vinyl.VodPopularityResponse{
				Popular: true,
			}
			mocks.vinyl.On("GetVodPopularity", ctx, mock.Anything, mock.Anything).Return(vodAggregation, nil)
			popularity, err := backend.GetVodPopularity(ctx, request)
			So(err, ShouldBeNil)
			So(popularity.Popular, ShouldBeTrue)
		})
		Convey("when GetVodPopularity fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodPopularity", ctx, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.GetVodPopularity(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
