package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestHardDeleteVods(t *testing.T) {
	Convey("when calling HardDeleteVods", t, func() {
		internalUpload := testdata.UploadVod()
		vinylUpload := testdata.VinylUploadVod()

		backend, mocks := initTestableBackend()
		ctx := context.Background()

		Convey("when HardDeleteVods succeeds", func() {
			mocks.vinyl.On("HardDeleteVods", mock.Anything, mock.Anything, mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vodResponse, err := backend.HardDeleteVods(ctx, &models.HardDeleteVodsRequest{
				VodIDs: []int64{vinylUpload.ID},
			})
			So(err, ShouldBeNil)
			So(&models.VodsResponse{
				Vods: []*models.Vod{internalUpload},
			}, ShouldResemble, vodResponse)
		})
		Convey("when HardDeleteVods fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("HardDeleteVods", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.HardDeleteVods(ctx, &models.HardDeleteVodsRequest{
				VodIDs: []int64{vinylUpload.ID},
			})
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
