package backend

import (
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// InternalCreateHighlight should make an underlying call to vinyl
func (b *backendImpl) InternalCreateHighlight(ctx context.Context, request *models.InternalCreateHighlightRequest) (*models.Vod, error) {
	b.stats.Inc(internalCreateHighlightAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.InternalCreateHighlight(ctx, converters.InternalCreateHighlightRequest(request), nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
