package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestInternalCreateHighlight(t *testing.T) {
	Convey("when calling InternalCreateHighlight", t, func() {
		showFormats := map[string]models.ShowFormat{
			"audio_only": models.ShowFormat{},
			"chunked":    models.ShowFormat{},
		}
		createHighlight := &models.InternalCreateHighlightRequest{
			SourceArchiveID: testdata.VodID1,
			OwnerID:         "owner",
			URI:             "uri",
			BroadcastID:     1,
			ShowFormats:     showFormats,
			Title:           "title",
			Duration:        1234,
		}

		backend, mocks := initTestableBackend()

		Convey("when InternalCreateHighlight succeeds", func() {
			upload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("InternalCreateHighlight", mock.Anything, mock.Anything, mock.Anything).Return(upload, nil)
			vod, err := backend.InternalCreateHighlight(context.Background(), createHighlight)
			So(err, ShouldBeNil)
			So(internalUpload, ShouldResemble, vod)
		})
		Convey("when InternalCreateHighlight fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("InternalCreateHighlight", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.InternalCreateHighlight(context.Background(), createHighlight)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
