package backend

import (
	"strconv"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// InternalGetVodByID should make an underlying call to vinyl
func (b *backendImpl) InternalGetVodByID(ctx context.Context, request *models.InternalGetVodByIDRequest) (*models.Vod, error) {
	b.stats.Inc(internalGetVodByIDAttemptStatStr, 1, 1.0)

	vinylVods, err := b.vinyl.GetVodsByIDs(ctx, []string{strconv.FormatInt(request.VodID, 10)}, &vinyl.GetVodParams{
		IncludePrivate:    true,
		IncludeProcessing: true,
	}, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVods[0]), nil
}
