package backend

import (
	"strings"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// InternalGetVodsByBroadcastIDs should make an underlying call to vinyl
func (b *backendImpl) InternalGetVodsByBroadcastIDs(ctx context.Context, request *models.InternalGetVodsByBroadcastIDsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(internalGetVodsByBroadcastIDsAttemptStatStr, 1, 1.0)

	broadcastIDStr := strings.Join(request.BroadcastIDs, ",")
	params := vinyl.GetVodsByQueryParams{
		BroadcastIDs: &broadcastIDStr,
	}
	vinylVods, err := b.vinyl.GetVodsByQuery(ctx, params, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
