package backend

import (
	"strconv"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"golang.org/x/net/context"
)

// InternalVodRemoveRecords should make an underlying call to vinyl
func (b *backendImpl) InternalVodRemoveRecords(ctx context.Context, request *models.InternalVodRemoveRecordsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(internalVodRemoveRecordsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	vinylVods, err := b.vinyl.DeleteVods(ctx, vinyl.DeleteVodsInput{
		VodIDs:      ids,
		Destructive: true,
	}, nil)
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
