package backend

import (
	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerCreateCustomThumbnailUploadRequest should make an underlying call to vinyl
func (b *backendImpl) ManagerCreateCustomThumbnailUploadRequest(ctx context.Context, request *models.ManagerCreateCustomThumbnailUploadRequestRequest) (*models.CreateCustomThumbnailUploadRequestResponse, error) {
	b.stats.Inc(managerCreateCustomThumbnailUploadRequestAttemptStatStr, 1, 1.0)

	createThumbnailUpload, err := b.vinyl.CreateCustomThumbnailUploadRequest(ctx, &vinyl.CustomThumbnailUploadRequestParams{
		VodID: request.VodID,
		CropX: int(request.CropX),
		CropY: int(request.CropY),
		CropH: int(request.CropH),
		CropW: int(request.CropW),
	}, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylCreateCustomThumbnailUpload(createThumbnailUpload), nil
}
