package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerCreateCustomThumbnailUploadRequest(t *testing.T) {
	Convey("when calling ManagerCreateCustomThumbnailUploadRequest", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerCreateCustomThumbnailUploadRequestRequest{
			VodID:  testdata.VodID1,
			CropX:  10,
			CropY:  20,
			CropH:  30,
			CropW:  40,
			UserID: 1234,
		}

		Convey("when ManagerCreateCustomThumbnailUploadRequest succeeds", func() {
			resp := &vinyl.CustomThumbnailUploadRequest{
				URL:      "url",
				UploadID: "upload",
			}
			mocks.vinyl.On("CreateCustomThumbnailUploadRequest", mock.Anything, mock.Anything, mock.Anything).Return(resp, nil)
			thumbnailsResp, err := backend.ManagerCreateCustomThumbnailUploadRequest(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when ManagerCreateCustomThumbnailUploadRequest fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("CreateCustomThumbnailUploadRequest", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerCreateCustomThumbnailUploadRequest(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
