package backend

import (
	"strings"

	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerCreateHighlight should make an underlying call to vinyl
func (b *backendImpl) ManagerCreateHighlight(ctx context.Context, request *models.ManagerCreateHighlightRequest) (*models.Vod, error) {
	b.stats.Inc(managerCreateHighlightAttemptStatStr, 1, 1.0)

	vinylVod, err := b.vinyl.CreateHighlight(ctx, vinyl.CreateHighlightInput{
		VodID:        request.VodID,
		Description:  request.Description,
		Game:         request.Game,
		Title:        request.Title,
		Language:     request.Language,
		StartSeconds: int(request.StartSeconds),
		EndSeconds:   int(request.EndSeconds),
		TagList:      strings.Join(request.TagList, ","),
		CreatedBy:    request.CreatedBy,
	}, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVod(vinylVod), nil
}
