package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerCreateHighlight(t *testing.T) {
	Convey("when calling ManagerCreateHighlight", t, func() {
		createHighlight := &models.ManagerCreateHighlightRequest{
			VodID:        testdata.VodID1,
			Description:  "description",
			Game:         "game",
			Title:        "title",
			Language:     "language",
			StartSeconds: 5,
			EndSeconds:   100,
			TagList:      []string{"tags"},
			CreatedBy:    12345,
			UserID:       1234,
		}

		backend, mocks := initTestableBackend()

		Convey("when ManagerCreateHighlight succeeds", func() {
			upload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("CreateHighlight", mock.Anything, mock.Anything, mock.Anything).Return(upload, nil)
			vod, err := backend.ManagerCreateHighlight(context.Background(), createHighlight)
			So(err, ShouldBeNil)
			So(internalUpload, ShouldResemble, vod)
		})
		Convey("when ManagerCreateHighlight fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("CreateHighlight", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerCreateHighlight(context.Background(), createHighlight)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
