package backend

import (
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerCreateVodAppeals should make an underlying call to vinyl
func (b *backendImpl) ManagerCreateVodAppeals(ctx context.Context, request *models.ManagerCreateVodAppealsRequest) error {
	b.stats.Inc(managerCreateVodAppealsAttemptStatStr, 1, 1.0)

	err := b.vinyl.CreateAppeals(ctx, converters.ConvertInternalToVinylCreateAppeals(request), &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	return b.ErrorHandle(err)
}
