package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerCreateVodAppeals(t *testing.T) {
	Convey("when calling ManagerCreateVodAppeals", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerCreateVodAppealsRequest{
			VodID:          testdata.VodID1,
			City:           "city",
			Country:        "country",
			FullName:       "full_name",
			State:          "state",
			StreetAddress1: "street_address1",
			StreetAddress2: "street_address2",
			Zipcode:        "zipcode",
			TrackAppeals: []models.TrackAppealRequest{
				models.TrackAppealRequest{
					AudibleMagicResponseID: 9999,
					Reason:                 "reason",
				},
			},
			UserID: 1234,
		}

		Convey("when ManagerCreateVodAppeals succeeds", func() {
			mocks.vinyl.On("CreateAppeals", mock.Anything, mock.Anything, mock.Anything).Return(nil)
			err := backend.ManagerCreateVodAppeals(ctx, request)
			So(err, ShouldBeNil)
		})
		Convey("when ManagerCreateVodAppeals fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("CreateAppeals", mock.Anything, mock.Anything, mock.Anything).Return(vinylErr)
			err := backend.ManagerCreateVodAppeals(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
