package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerDeleteThumbnails should make an underlying call to vinyl
func (b *backendImpl) ManagerDeleteThumbnails(ctx context.Context, request *models.ManagerDeleteThumbnailsRequest) error {
	b.stats.Inc(managerDeleteThumbnailsAttemptStatStr, 1, 1.0)

	err := b.vinyl.DeleteThumbnails(ctx, strconv.FormatInt(request.VodID, 10), &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	return b.ErrorHandle(err)
}
