package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerGetUserVideoPrivacyProperties should make an underlying call to vinyl
func (b *backendImpl) ManagerGetUserVideoPrivacyProperties(ctx context.Context, request *models.ManagerGetUserVideoPrivacyPropertiesRequest) (*models.UserVideoPrivacyPropertiesResponse, error) {
	b.stats.Inc(managerGetUserVideoPrivacyPropertiesAttemptStatStr, 1, 1.0)

	userVideoPrivacyProperties, err := b.vinyl.GetUserVideoPrivacyProperties(ctx, strconv.FormatInt(request.ChannelID, 10), &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylUserVideoPrivacyProperties(userVideoPrivacyProperties), nil
}
