package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerGetUserVideoPrivacyProperties(t *testing.T) {
	Convey("when calling ManagerGetUserVideoPrivacyProperties", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerGetUserVideoPrivacyPropertiesRequest{
			ChannelID: 1234,
			UserID:    1234,
		}

		Convey("when ManagerGetUserVideoPrivacyProperties succeeds", func() {
			userVideoPrivacyProperties := testdata.VinylUserVideoPrivacyProperties()
			mocks.vinyl.On("GetUserVideoPrivacyProperties", mock.Anything, mock.Anything, mock.Anything).Return(userVideoPrivacyProperties, nil)
			thumbnailsResp, err := backend.ManagerGetUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when ManagerGetUserVideoPrivacyProperties fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetUserVideoPrivacyProperties", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerGetUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
