package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerGetUserVodProperties should make an underlying call to vinyl
func (b *backendImpl) ManagerGetUserVodProperties(ctx context.Context, request *models.ManagerGetUserVodPropertiesRequest) (*models.UserVodPropertiesResponse, error) {
	b.stats.Inc(managerGetUserVodPropertiesAttemptStatStr, 1, 1.0)

	userVodProperties, err := b.vinyl.GetUserVodProperties(ctx, strconv.FormatInt(request.ChannelID, 10), &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylUserVodProperties(userVodProperties), nil
}
