package backend

import (
	"context"
	"errors"
	"testing"

	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerGetUserVodProperties(t *testing.T) {
	Convey("when calling ManagerGetUserVodProperties", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerGetUserVodPropertiesRequest{
			ChannelID: 1234,
			UserID:    1234,
		}

		Convey("when ManagerGetUserVodProperties succeeds", func() {
			userVodProperties := testdata.VinylUserVodProperties()
			mocks.vinyl.On("GetUserVodProperties", mock.Anything, mock.Anything, mock.Anything).Return(userVodProperties, nil)
			thumbnailsResp, err := backend.ManagerGetUserVodProperties(ctx, request)
			So(err, ShouldBeNil)
			So(thumbnailsResp, ShouldNotBeNil)
		})
		Convey("when ManagerGetUserVodProperties fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetUserVodProperties", mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerGetUserVodProperties(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
