package backend

import (
	"net/http"
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerGetVodByID should make an underlying call to vinyl
func (b *backendImpl) ManagerGetVodByID(ctx context.Context, request *models.ManagerGetVodByIDRequest) (*models.Vod, error) {
	b.stats.Inc(managerGetVodByIDAttemptStatStr, 1, 1.0)

	vinylVods, err := b.vinyl.GetVodsByIDs(ctx, []string{strconv.FormatInt(request.VodID, 10)}, nil, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	if len(vinylVods) == 0 {
		return nil, &twitchclient.Error{StatusCode: http.StatusNotFound, Message: "Empty vinyl list in manager get vod by id"}
	}
	return converters.ConvertVinylVod(vinylVods[0]), nil
}
