package backend

import (
	"net/http"
	"strconv"

	"code.justin.tv/foundation/twitchclient"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerGetVodMuteInfo should make an underlying call to vinyl
func (b *backendImpl) ManagerGetVodMuteInfo(ctx context.Context, request *models.ManagerGetVodMuteInfoRequest) (*models.VodMuteInfoResponse, error) {
	b.stats.Inc(managerGetVodMuteInfoAttemptStatStr, 1, 1.0)

	getVodParams := vinyl.NewGetVodParams()
	getVodParams.WithMuteInfo = true
	vinylVods, err := b.vinyl.GetVodsByIDs(ctx, []string{strconv.FormatInt(request.VodID, 10)}, getVodParams, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	if len(vinylVods) == 0 {
		return nil, &twitchclient.Error{StatusCode: http.StatusNotFound, Message: "Empty vinyl list in internal get vod mute info"}
	}
	return converters.ConvertMuteInfo(vinylVods[0]), nil
}
