package backend

import (
	"context"
	"errors"
	"strconv"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerGetVodMuteInfo(t *testing.T) {
	Convey("when calling ManagerGetVodMuteInfo", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerGetVodMuteInfoRequest{
			VodID:  testdata.VodID1,
			UserID: 1234,
		}

		Convey("when ManagerGetVodMuteInfo succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			mocks.vinyl.On("GetVodsByIDs", ctx, []string{strconv.FormatInt(testdata.VodID1, 10)}, mock.Anything, mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vod, err := backend.ManagerGetVodMuteInfo(ctx, request)
			So(err, ShouldBeNil)
			So(vod, ShouldNotBeNil)
		})
		Convey("when ManagerGetVodMuteInfo fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodsByIDs", ctx, []string{strconv.FormatInt(testdata.VodID1, 10)}, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerGetVodMuteInfo(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
