package backend

import (
	"context"
	"errors"
	"strconv"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerGetVodMuteInfos(t *testing.T) {
	Convey("when calling ManagerGetVodMuteInfos", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerGetVodMuteInfosRequest{
			VodIDs: []int64{testdata.VodID1},
			UserID: 1234,
		}

		Convey("when ManagerGetVodMuteInfos succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			mocks.vinyl.On("GetVodsByIDs", ctx, []string{strconv.FormatInt(testdata.VodID1, 10)}, mock.Anything, mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vod, err := backend.ManagerGetVodMuteInfos(ctx, request)
			So(err, ShouldBeNil)
			So(vod, ShouldNotBeNil)
		})
		Convey("when ManagerGetVodMuteInfos fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("GetVodsByIDs", ctx, []string{strconv.FormatInt(testdata.VodID1, 10)}, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerGetVodMuteInfos(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
