package backend

import (
	"strconv"
	"strings"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	vinyl "code.justin.tv/vod/vodapi/pkg/vinyl"
	"golang.org/x/net/context"
)

// ManagerGetVodsByUserIncludeBannedUsers should make an underlying call to vinyl
func (b *backendImpl) ManagerGetVodsByUserIncludeBannedUsers(ctx context.Context, request *models.ManagerGetVodsByUserIncludeBannedUsersRequest) (*models.VodsResponse, error) {
	b.stats.Inc(managerGetVodsByUserIncludeBannedUsersAttemptStatStr, 1, 1.0)

	userIDStr := strconv.FormatInt(request.ChannelID, 10)
	getVodsInput := &vinyl.GetVodsByUserIncludeBannedUsersInput{
		ChannelID:     userIDStr,
		BroadcastType: strings.Join(request.BroadcastTypes, ","),
		Limit:         request.Limit,
		Offset:        request.Offset,
	}
	vinylVods, err := b.vinyl.GetVodsByUserIncludeBannedUsers(ctx, getVodsInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
