package backend

import (
	"strconv"
	"strings"

	"code.justin.tv/foundation/twitchclient"
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerInternalGetVodsByUser should make an underlying call to vinyl
func (b *backendImpl) ManagerInternalGetVodsByUser(ctx context.Context, request *models.ManagerInternalGetVodsByUserRequest) (*models.VodsResponse, error) {
	b.stats.Inc(managerInternalGetVodsByUserAttemptStatStr, 1, 1.0)

	userIDStr := strconv.FormatInt(request.ChannelID, 10)
	getUserInput := vinyl.GetVodsByUserInput{
		BroadcastType:   strings.Join(request.BroadcastTypes, ","),
		Language:        request.Language,
		Status:          request.Status,
		PublishedWithin: request.PublishedWithin,
		Sort:            request.Sort,
		Limit:           int(request.Limit),
		Offset:          int(request.Offset),
		RecordedAfter:   request.RecordedAfter,
		RecordedBefore:  request.RecordedBefore,
		GetVodParams: &vinyl.GetVodParams{
			IncludePrivate:    true,
			IncludeProcessing: true,
		},
	}
	vinylVods, err := b.vinyl.GetVodsByOwner(ctx, userIDStr, getUserInput, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods.Vods), nil
}
