package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerSearchVods should make an underlying call to vinyl
func (b *backendImpl) ManagerSearchVods(ctx context.Context, request *models.ManagerSearchVodsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(managerSearchVodsAttemptStatStr, 1, 1.0)

	userIDStr := strconv.FormatInt(request.ChannelID, 10)
	limitStr := strconv.FormatInt(request.Limit, 10)
	offsetStr := strconv.FormatInt(request.Offset, 10)
	vinylVods, err := b.vinyl.SearchVods(ctx, userIDStr, request.Search, limitStr, offsetStr, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
