package backend

import (
	"context"
	"errors"
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	service_errors "code.justin.tv/vod/vodapi/internal/errors"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

func TestManagerSearchVods(t *testing.T) {
	Convey("when calling ManagerSearchVods", t, func() {
		backend, mocks := initTestableBackend()
		ctx := context.Background()

		request := &models.ManagerSearchVodsRequest{
			ChannelID: 1234,
			Search:    "search",
			Limit:     100,
			Offset:    0,
			UserID:    1234,
		}

		Convey("when ManagerSearchVods succeeds", func() {
			vinylUpload := testdata.VinylUploadVod()
			internalUpload := testdata.UploadVod()
			mocks.vinyl.On("SearchVods", ctx, mock.Anything, mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return([]*vinyl.Vod{vinylUpload}, nil)
			vods, err := backend.ManagerSearchVods(ctx, request)
			So(err, ShouldBeNil)
			So(len(vods.Vods), ShouldEqual, 1)
			So(vods.Vods[0], ShouldResemble, internalUpload)
		})
		Convey("when ManagerSearchVods fails", func() {
			mocks.MockErrorHandle()
			vinylErr := errors.New("something bad happened")
			mocks.vinyl.On("SearchVods", ctx, mock.Anything, mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(nil, vinylErr)
			_, err := backend.ManagerSearchVods(ctx, request)
			So(err, ShouldResemble, &service_errors.BackendError{Err: vinylErr})
		})
		mocks.AssertExpectations(t)
	})
}
