package backend

import (
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/pkg/shared"
	"golang.org/x/net/context"
)

// ManagerSoftDeleteVods should make an underlying call to vinyl
func (b *backendImpl) ManagerSoftDeleteVods(ctx context.Context, request *models.ManagerSoftDeleteVodsRequest) (*models.VodsResponse, error) {
	b.stats.Inc(managerSoftDeleteVodsAttemptStatStr, 1, 1.0)

	ids := make([]string, len(request.VodIDs))
	for i, id := range request.VodIDs {
		ids[i] = strconv.FormatInt(id, 10)
	}
	vinylVods, err := b.vinyl.DeleteVodsExternal(ctx, ids, &twitchclient.ReqOpts{
		AuthorizationToken: shared.AuthorizationTokenFromContext(ctx),
	})
	if err != nil {
		return nil, b.ErrorHandle(err)
	}
	return converters.ConvertVinylVods(vinylVods), nil
}
